#ifndef _lf_scheduler_h_
#define _lf_scheduler_h_
/*
 * Sort-of Generic Event scheduler
 */

#ifndef _WIN32
#include <sys/time.h>
#else
#include <winsock2.h>
#endif

/*
 * Prototypes
 */
typedef void (*lf_event_handler_t)(void *);
void lf_scheduler_init(void);
void lf_scheduler_finalize(void);
void lf_schedule_breakout(void);

struct lf_event *lf_schedule_event(
  lf_event_handler_t handler,
  void *context,
  uint32_t millisecs);
  
void lf_remove_event(
  struct lf_event *ep);

int lf_check_events(void);

/* return difference between two timevals in ms (t1 - t2) */
static inline int32_t
tv_diff(
  struct timeval *t1,
  struct timeval *t2)
{
  int32_t ms;

  ms = (t1->tv_sec - t2->tv_sec) * 1000;
  ms += (t1->tv_usec - t2->tv_usec) / 1000;
  return ms;
}

/*
 * add milliseconds to a timeval struct
 */
static inline void
tv_add(
  struct timeval *t,
  int32_t ms)
{
  t->tv_usec += (ms%1000) * 1000;
  if (t->tv_usec >= 1000000) {
    t->tv_usec -= 1000000;
    t->tv_sec += 1;
  } else if (t->tv_usec < 0) {
    t->tv_usec += 1000000;
    t->tv_sec -= 1;
  }

  t->tv_sec += ms/1000;
}

/* Description of an event */
struct lf_event {
  void (*handler)(void *);
  void *context;

  struct timeval timeout;		/* time for this one to fire */

  struct lf_event *prev;		/* previous in list */
  struct lf_event *next;		/* next in list */

  struct lf_event *peer_prev;		/* events with same times */
  struct lf_event *peer_next;
};
 
#endif /* _lf_scheduler_h_ */
